<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations. ]qP&bTMUVaGB
     */
    public function up(): void
    {

        Schema::create('tell_users', function (Blueprint $table) {
            $table->id();
            $table->string('tell_id')->unique();
            $table->string('ref_id')->nullable();
            $table->integer('govern_amount')->default(0);
            $table->integer('local_amount')->default(0);
            $table->integer('ref_limit')->default(2);
            $table->integer('used_ref')->default(0);
            $table->json('ref_json')->nullable();
            $table->foreignId('capacity_id')->constrained()->default(1);
            $table->foreignId('pertap_id')->constrained()->default(1);
            $table->foreignId('daily_charge_id')->constrained()->default(1);
            $table->foreignId('daily_spin_id')->constrained()->default(1);
            $table->integer('today_charge')->default(1);
            $table->string('status')->default("normal");
            $table->boolean('isBan')->default(false);
            $table->boolean('is_watched')->default(false);
            $table->boolean('is_used_spin')->default(false);
            $table->integer('get_reward')->default(0);
            $table->timestamp('last_tap')->default("2020-01-11T00:00:0.0");
            $table->json('task')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tell_users');
    }
};
