<?php

namespace App\Commands;

use Telegram\Bot\Actions;
use Telegram\Bot\Commands\Command;

class StartCommand extends Command
{
    protected $name = 'start';

    public function handle()
    {
        $update = $this->getUpdate();
        $chat = $update->getMessage()->getChat();

        $this->replyWithMessage('Welcome to the bot, ' . $chat->getFirstName() . '!');

        // Optionally, send a keyboard with buttons
        $this->replyWithKeyboard([
            'keyboard' => [
                [[
                    'text' => 'Button 1',
                    'callback_data' => 'button_1_data',
                ], [
                    'text' => 'Button 2',
                    'callback_data' => 'button_2_data',
                ]],
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false,
        ]);
    }
}
